PRINT '> NFE - SCRIPT #0011';

IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_NFE_PAINEL]'))
DROP VIEW [dbo].[V_NFE_PAINEL]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [dbo].[V_NFE_PAINEL]
AS

WITH
	PANIEL_NFE AS (
SELECT 
	'VALIDADA' AS STATUS
	, 'SAIDA' AS MOVIMENTACAO, COUNT(*) AS QTDE
	FROM EST_NF_SAI  NF
                INNER JOIN EST_NF_SERIE SERIE
                        ON  NF.CD_NF_SERIE = SERIE.CD_NF_SERIE
                        AND SERIE.ESPC = 'NFE'
                INNER JOIN EST_NF_SAI_NFE NFE
                        ON  NF.CD_EMP = NFE.CD_EMP
                        AND NF.CD_FILIAL = NFE.CD_FILIAL
                        AND NF.CD_NF = NFE.CD_NF
        WHERE   NF.DT_EMI_NF =  CONVERT(CHAR(10),GETDATE(),112)
                AND NFE.NR_PROTOCOLO IS NOT NULL
                AND NFE.NR_AUTORIZADOR IS NOT NULL
UNION
SELECT 'NAO_VALIDADA' AS STATUS,'SAIDA' AS MOVIMENTACAO, COUNT(*) AS QTDE
FROM 
	EST_NFE_LOTE_SAI INNER JOIN EST_NF_SAI ON  
	EST_NFE_LOTE_SAI.CD_EMP = EST_NF_SAI.CD_EMP AND  
	EST_NFE_LOTE_SAI.CD_FILIAL = EST_NF_SAI.CD_FILIAL AND 
	EST_NFE_LOTE_SAI.CD_NF = EST_NF_SAI.CD_NF  
	INNER JOIN EST_NFE_LOTE ON  
	EST_NFE_LOTE_SAI.CD_NFE_LOTE = EST_NFE_LOTE.CD_NFE_LOTE 
	INNER JOIN GLB_USU ON 
	EST_NFE_LOTE.CD_USU = GLB_USU.CD_USU 
	LEFT OUTER JOIN EST_NF_SAI_NFE_PEND ON 
	EST_NFE_LOTE_SAI.CD_EMP = EST_NF_SAI_NFE_PEND.CD_EMP AND 
	EST_NFE_LOTE_SAI.CD_FILIAL = EST_NF_SAI_NFE_PEND.CD_FILIAL AND 
	EST_NFE_LOTE_SAI.CD_NF = EST_NF_SAI_NFE_PEND.CD_NF 
	LEFT OUTER JOIN  EST_NF_SAI_NFE ON
	EST_NFE_LOTE_SAI.CD_EMP = EST_NF_SAI_NFE.CD_EMP AND
	EST_NFE_LOTE_SAI.CD_FILIAL = EST_NF_SAI_NFE.CD_FILIAL AND
	EST_NFE_LOTE_SAI.CD_NF = EST_NF_SAI_NFE.CD_NF 

WHERE 
	EST_NFE_LOTE_SAI.CD_EMP =1 
	AND EST_NF_SAI.DT_EMI_NF >= CONVERT(CHAR(10),GETDATE()-7,112)
	AND EST_NF_SAI_NFE_PEND.CD_NF IS NULL
	AND EST_NF_SAI_NFE.CD_NF  IS NULL
	AND EST_NF_SAI.STS_NF = 0
UNION
SELECT 	'PENDENTE' AS STATUS,'SAIDA' AS MOVIMENTACAO, COUNT(*) AS QTDE
FROM	V_EST_NF_NFE_PENDENTE_EMISSAO WHERE TIPO_NF = 1 AND PEND_SOLUC = 0
UNION
SELECT 'COM_ERRO' AS STATUS,'SAIDA' AS MOVIMENTACAO, COUNT(*) AS QTDE
FROM	V_EST_NF_NFE_PENDENTE_EMISSAO WHERE TIPO_NF = 1 AND PEND_SOLUC = 1
--ENTRADAS
UNION 
SELECT 'VALIDADA' AS STATUS,'ENTRADA' AS MOVIMENTACAO, COUNT(*) AS QTDE
        FROM    EST_NF_ENT  NF
                INNER JOIN EST_NF_SERIE SERIE
                        ON  NF.CD_NF_SERIE = SERIE.CD_NF_SERIE
                        AND SERIE.ESPC = 'NFE'
                INNER JOIN EST_NF_ENT_NFE NFE
                        ON  NF.CD_EMP = NFE.CD_EMP
                        AND NF.CD_FILIAL = NFE.CD_FILIAL
                        AND NF.CD_NF = NFE.CD_NF
        WHERE   NF.DT_ENT = CONVERT(CHAR(10),GETDATE(),112)
                AND NFE.NR_PROTOCOLO IS NOT NULL
                AND NFE.NR_AUTORIZADOR IS NOT NULL
UNION
SELECT 'NAO_VALIDADA' AS STATUS,'ENTRADA' AS MOVIMENTACAO, COUNT(*) AS QTDE
FROM 
	EST_NFE_LOTE_ENT INNER JOIN EST_NF_ENT ON  
	EST_NFE_LOTE_ENT.CD_EMP = EST_NF_ENT.CD_EMP AND  
	EST_NFE_LOTE_ENT.CD_FILIAL = EST_NF_ENT.CD_FILIAL AND 
	EST_NFE_LOTE_ENT.CD_NF = EST_NF_ENT.CD_NF  
	INNER JOIN EST_NFE_LOTE ON  
	EST_NFE_LOTE_ENT.CD_NFE_LOTE = EST_NFE_LOTE.CD_NFE_LOTE 
	INNER JOIN GLB_USU ON 
	EST_NFE_LOTE.CD_USU = GLB_USU.CD_USU 
	LEFT OUTER JOIN EST_NF_ENT_NFE_PEND ON 
	EST_NFE_LOTE_ENT.CD_EMP = EST_NF_ENT_NFE_PEND.CD_EMP AND 
	EST_NFE_LOTE_ENT.CD_FILIAL = EST_NF_ENT_NFE_PEND.CD_FILIAL AND 
	EST_NFE_LOTE_ENT.CD_NF = EST_NF_ENT_NFE_PEND.CD_NF 
	LEFT OUTER JOIN  EST_NF_ENT_NFE ON
	EST_NFE_LOTE_ENT.CD_EMP = EST_NF_ENT_NFE.CD_EMP AND
	EST_NFE_LOTE_ENT.CD_FILIAL = EST_NF_ENT_NFE.CD_FILIAL AND
	EST_NFE_LOTE_ENT.CD_NF = EST_NF_ENT_NFE.CD_NF 

WHERE 
	EST_NFE_LOTE_ENT.CD_EMP =1 
	AND EST_NF_ENT.DT_EMI_NF >= CONVERT(CHAR(10),GETDATE()-7,112)
	AND EST_NF_ENT_NFE_PEND.CD_NF IS NULL
	AND EST_NF_ENT_NFE.CD_NF  IS NULL
	AND EST_NF_ENT.STS_NF = 0
	
UNION
SELECT 	'PENDENTE' AS STATUS,'ENTRADA' AS MOVIMENTACAO, COUNT(*) AS QTDE
FROM	V_EST_NF_NFE_PENDENTE_EMISSAO WHERE TIPO_NF = 0 AND PEND_SOLUC = 0
UNION
SELECT 'COM_ERRO' AS STATUS,'ENTRADA' AS MOVIMENTACAO, COUNT(*) AS QTDE
FROM	V_EST_NF_NFE_PENDENTE_EMISSAO WHERE TIPO_NF = 0 AND PEND_SOLUC = 1
UNION
SELECT 'XML_NAO_ENCONTRADO' AS STAUS, 'ENTRADA' AS MOVIMENTACAO, COUNT(1) AS QUANTIDADE  FROM
EST_NF_ENT_DANFE_PROVISORIO_NAO_ENCONTRADO
)
SELECT
	1 AS COD
	, 'VALIDADAS NO DIA' as STATUS
	, (SELECT QTDE FROM PANIEL_NFE WHERE STATUS = 'VALIDADA' AND MOVIMENTACAO = 'ENTRADA') AS ENTRADAS
	, (SELECT QTDE FROM PANIEL_NFE WHERE STATUS = 'VALIDADA' AND MOVIMENTACAO = 'SAIDA') AS SAIDAS
UNION ALL
SELECT
	2 AS COD
	, 'NAO VALIDADAS' as STATUS
	, (SELECT QTDE FROM PANIEL_NFE WHERE STATUS = 'NAO_VALIDADA' AND MOVIMENTACAO = 'ENTRADA') AS ENTRADAS
	, (SELECT QTDE FROM PANIEL_NFE WHERE STATUS = 'NAO_VALIDADA' AND MOVIMENTACAO = 'SAIDA') AS SAIDAS
UNION ALL
SELECT
	3 AS COD
	, 'PENDENTES EMISSAO' as STATUS
	, (SELECT QTDE FROM PANIEL_NFE WHERE STATUS = 'PENDENTE' AND MOVIMENTACAO = 'ENTRADA') AS ENTRADAS
	, (SELECT QTDE FROM PANIEL_NFE WHERE STATUS = 'PENDENTE' AND MOVIMENTACAO = 'SAIDA') AS SAIDAS
UNION ALL
SELECT
	4 AS COD
	, 'PENDENTES SOLUCAO' as STATUS
	, (SELECT QTDE FROM PANIEL_NFE WHERE STATUS = 'COM_ERRO' AND MOVIMENTACAO = 'ENTRADA') AS ENTRADAS
	, (SELECT QTDE FROM PANIEL_NFE WHERE STATUS = 'COM_ERRO' AND MOVIMENTACAO = 'SAIDA') AS SAIDAS
GO

PRINT '    < [OK]';
